#include <cstdio>
#include <cstring>
#include <queue>
#include <algorithm>
#include <ctime>
using namespace std;
const int N = (int) 2e5 + 1;
const int INF = (int) 1e9;
int tcnt, n, k, value[N];
char s[N], t[N], best[N];

struct segment {
	int sum, l, r;
	segment(): sum(-INF), l(-1), r(-1) {}
	segment(int sum, int l, int r): sum(sum), l(l), r(r) {}
};

segment operator+(const segment& a, const segment& b) {
	return segment(a.sum + b.sum, a.l, b.r);
}

bool operator<(const segment& a, const segment& b) {
	return (a.sum < b.sum);
}

struct tnode {
	segment sum, max_sum, max_pref_sum, max_suf_sum;
	tnode(segment base): sum(base), max_sum(base), max_pref_sum(base), max_suf_sum(base) {}
	tnode() {}
} rmq_min[4 * N], rmq_max[4 * N];

bool operator<(const tnode& a, const tnode& b) {
	return (a.max_sum < b.max_sum);
}

tnode operator+(const tnode& a, const tnode& b) {
	if (a.sum.l == -1) return b;
	if (b.sum.l == -1) return a;
	tnode c;
	c.sum = a.sum + b.sum;
	c.max_sum = max(max(a.max_sum, b.max_sum), a.max_suf_sum + b.max_pref_sum);
	c.max_pref_sum = max(a.max_pref_sum, a.sum + b.max_pref_sum);
	c.max_suf_sum = max(a.max_suf_sum + b.sum, b.max_suf_sum);
	return c;
}

tnode get(tnode* rmq, int t, int l, int r, int x, int y) {
	if ((y <= l) || (r <= x)) return tnode();
	if ((x <= l) && (r <= y)) return rmq[t];
	int m = (l + r) / 2;
	return get(rmq, t * 2 + 1, l, m, x, y) + get(rmq, t * 2 + 2, m, r, x, y);
}

void solve(int k, int c) {
	priority_queue<tnode> in, out;
	out.push(get(rmq_max, 0, 0, n, 0, n));
	for (int i = 0; i < k; ++i)
		if (!out.empty() && (out.top().max_sum.sum >= 0) && (in.empty() || (out.top().max_sum.sum >= in.top().max_sum.sum))) {
			tnode to_erase = out.top();
			segment old = to_erase.sum, part = to_erase.max_sum;
			out.pop();
			if (old.l < part.l) out.push(get(rmq_max, 0, 0, n, old.l, part.l));
			if (part.r < old.r) out.push(get(rmq_max, 0, 0, n, part.r, old.r));
			in.push(get(rmq_min, 0, 0, n, part.l, part.r));
		} else if (!in.empty() && (in.top().max_sum.sum >= 0)) {
			tnode to_erase = in.top();
			segment old = to_erase.sum, part = to_erase.max_sum;
			in.pop();
			if (old.l < part.l) in.push(get(rmq_min, 0, 0, n, old.l, part.l));
			if (part.r < old.r) in.push(get(rmq_min, 0, 0, n, part.r, old.r));
			out.push(get(rmq_max, 0, 0, n, part.l, part.r));
		} else
			break;
	fill(t, t + n, '0' + c);
	while (!in.empty()) {
		fill(t + in.top().sum.l, t + in.top().sum.r, '0' + (c ^ 1));
		in.pop();
	}
	t[n] = 0;
}

void init(int t, int l, int r) {
	if (l == r - 1) {
		rmq_max[t] = tnode(segment(value[l], l, r));
		rmq_min[t] = tnode(segment(-value[l], l, r));
	} else {
		int m = (l + r) / 2;
		init(t * 2 + 1, l, m);
		init(t * 2 + 2, m, r);
		rmq_min[t] = rmq_min[t * 2 + 1] + rmq_min[t * 2 + 2];
		rmq_max[t] = rmq_max[t * 2 + 1] + rmq_max[t * 2 + 2];
	}
}

int diff(char* a, char* b) {
    int ret = 0;
    for (int i = 0; i < n; ++i)
        ret += (a[i] != b[i]);
    return ret;
}

int main() {
	double start = clock();
    scanf("%d%d%s", &n, &k, s);
    int opt_res = n + 1;
    for (int c = 0; c < 2; ++c) {
        for (int i = 0; i < n; ++i)
            value[i] = ((s[i] == '0' + c) ? -1 : 1);
        if (k % 2 == 0)
            value[0] += INF;
        init(0, 0, n);
        solve(k / 2, c);
        int res = 0;
        for (int i = 0; i < n; ++i)
            res += (s[i] != t[i]);
        if (res < opt_res)
            opt_res = res, strcpy(best, t);
    }
    printf("%d\n", diff(best, s));
	fprintf(stderr, "%.2f\n", (clock() - start) / CLOCKS_PER_SEC);
	return 0;
}
